#include <SD.h>  // Pour la communication avec la carte SD


#define freq 30

/* Broche CS de la carte SD */
const byte SDCARD_CS_PIN = 10; // TODO A remplacer suivant votre shield SD
String data_filename_name = "data";
String data_filename_ext  = ".csv";
String data_filename = "";
File fichier;

// Messages d'erreur
String file_doesnt_exist = "Fichier non-existant.";
String file_cant_open = "Impossible d'ouvrir le fichier.";


unsigned long current_iter = 0;
unsigned long max_iter = 54000;
unsigned long start_time;

String inputString = "";         // a String to hold incoming data
bool stringComplete = false;


void serialEvent() {
  while (Serial.available()) {
    char inChar = (char)Serial.read();
    inputString += inChar;
    if (inChar == '\n') {
      stringComplete = true;

      if (current_iter < max_iter) {
        current_iter = max_iter;
      }
    }
  }
}

void setup() {

  /* Initialisation du port série (debug) */
  Serial.begin(115200);

  inputString.reserve(200);

  /* Initialisation du port SPI */
  pinMode(10, OUTPUT);

  /* Initialisation de la carte SD */
  Serial.print(F("Init SD card... "));
  if (!SD.begin(SDCARD_CS_PIN)) {
    Serial.println(F("FAIL"));
    for (;;); //  appui sur bouton RESET
  }

  Serial.println(F("OK"));


}

void loop() {

  if (current_iter == 0) {
    int fname_num = 0;
    do {
      data_filename = data_filename_name + fname_num + data_filename_ext;
      fname_num++;
    } while (SD.exists(data_filename));

    Serial.print("Prochain fichier : ");
    Serial.println(data_filename);

    fichier = SD.open(data_filename, FILE_WRITE);
    if (!fichier) {
      // Erreur d'ouverture du fichier
      Serial.println(file_cant_open);
      //for(;;); // Attend appui sur bouton RESET
    }

    start_time = millis();
  }

  if (current_iter < max_iter) {
    fichier.print(analogRead(A5), 10);
    fichier.print(",");
    fichier.print(analogRead(A6), 10);
    fichier.print(",");
    fichier.println(analogRead(A7), 10);
    if (current_iter % 100 == 0) {
      fichier.flush();
    }

    delay(((current_iter + 1) * 1000 / freq) - (millis() - start_time)); // assure une fréquence à peu près stable

    /*if(current_iter%10==0) {
      Serial.print(current_iter,10);
      Serial.println("");
      }*/
    current_iter++;
  }
  if (current_iter == max_iter) {
    fichier.close();
    Serial.println(F("Fermeture du fichier."));
    current_iter++;
  }

  if (stringComplete) {
    if (inputString.startsWith("end")) {
      Serial.println("(Rien)");
    } else if (inputString.startsWith("start")) {
      current_iter = 0; // pour debug et essais
    } else if (inputString.startsWith("dir")) {
      File directory = SD.open("/");
      File entry = directory.openNextFile();
      while (entry) {
        /* Affiche le nom du fichier courant */
        if (!entry.isDirectory()) {
          Serial.println(entry.name());
        }
        /* Ferme le fichier et ouvre le suivant */
        entry.close();
        entry = directory.openNextFile();
      }
      /* Revient au début du dossier */
      directory.rewindDirectory();
    } else if (inputString.startsWith("open")) {
      String fname = inputString.substring(5);
      fname.replace("\n", "");
      if (!SD.exists(fname)) {
        Serial.println(file_doesnt_exist);
      } else {
        File to_disp = SD.open(fname);
        if (!to_disp) {
          Serial.println(file_cant_open);
        } else {
          while (to_disp.available() > 0) {
            // Affiche un octet du fichier tant qu'il y a des données à lire
            Serial.write(to_disp.read());
          }
        }
        to_disp.close();
      }
    } else if (inputString.startsWith("rm")) {
      String fname = inputString.substring(3);
      fname.replace("\n", "");
      if (!SD.exists(fname)) {
        Serial.println(file_doesnt_exist);
      } else {
        if (SD.remove(fname)) {
          Serial.println(F("Fichier supprimé."));
        } else {
          Serial.println(F("Erreur lors de la suppression."));
        }
      }
    } else if (inputString.startsWith("size")) {
      String fname = inputString.substring(5);
      fname.replace("\n", "");
      if (!SD.exists(fname)) {
        Serial.println(file_doesnt_exist);
      } else {
        File to_disp = SD.open(fname);
        if (!to_disp) {
          Serial.println(file_cant_open);
        } else {
          Serial.println(to_disp.size(), 10);
        }
        to_disp.close();
      }
    } else {
      Serial.println(inputString);
    }
    inputString = "";
    stringComplete = false;
  }

}
